 
# Synthetic experiment for supervised learning

#generate a clutering data 
gen_data1 <- function(rho){
  n <- 100
  p <- 10
  #rho <- 0.5 
  X1 <- genDesignMat(n,p,rho)
  X2 <- genDesignMat(n,p,-rho)
  
  X <- rbind(X1, X2)
  Y <- gl(2, n) #create factor labels 

  ind <- sample(2,nrow(X),replace=TRUE,prob=c(0.7,0.3))
  X_train <- X[ind==1,]
  X_test <- X[ind==2,]
  Y_train <- Y[ind==1]
  Y_test <- Y[ind==2]
  list(X_train=X_train, X_test=X_test, Y_train=Y_train, Y_test=Y_test)
}



gen_data2 <- function(n, p){
  sigma <- 1 #10 was too large 
  X <- matrix(NA, nrow=n, ncol=p)
  X[,1:15] <- genDesignMat(n,15,0.0)
  X[,16:p] <- genDesignMat(n,(p-15),0)
  #beta <- c(rep(2.5, 5), rep(1.5, 5), rep(0.5, 5), rep(0, p-15))
  beta <- c(rep(2.5, 5), rep(1.5, 5), rep(0, p-10))
  #mu <- X %*% matrix(beta, ncol=1)
  mu <- 15 * X[,1] * X[,1] + 10 * X[,2] * X[,3] + 1 * X[,4] * X[,5]
  y <- mu + rnorm(n, mean = 0, sd = sigma)
  list(X=X, y=y, mu=mu)
}

.f <- function(){  
  n <- 150  
  p <- 20  
  dat1 <- gen_data2(n, p)
  #lm(y ~ X[,1:15], data = dat1)
}





 







